<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Deposit;
use App\Models\Berita;
use App\Models\Seting;
use Illuminate\Support\Facades\Auth;

class DepositController extends Controller
{
    public function create()
    {
        return view('components.deposit', ['data' => Deposit::where('username', Auth::user()->username)->orderBy('created_at', 'desc')->paginate(10),
        'logoheader' => Berita::where('tipe', 'logoheader')->latest()->first(),
          'logofooter' => Berita::where('tipe', 'logofooter')->latest()->first()
        ]);
    }

    public function store(Request $request)
    {
        $api = \DB::table('setings')->where('id',1)->first();
        $request->validate([
            'jumlah' => 'required|numeric|min:1',
            'metode' => 'required'
        ], [
            'jumlah.numeric' => "Jumlah tidak valid",
            "jumlah.min" => "Jumlah tidak valid",
            'jumlah.required' => "Harap mengisi jumlah",
            'metode.required' => "Harap mengisi metode"
        ]);

        if ($request->metode == "OVO") {
            $nomor = $api->ovo_admin;
        } else if ($request->metode == "GOPAY") {
            $nomor = $api->gopay_admin;
        } else if ($request->metode == "SHOPEPAY") {
            $nomor = $api->shopeepay_admin;
        } else if ($request->metode == "DANA") {
            $nomor = $api->dana_admin;
        } else if ($request->metode == "BCA") {
            $nomor = $api->bca_admin;
        } else if ($request->metode == "SEABANK") {
            $nomor = $api->seabank_admin;
        }else if ($request->metode == "QRIS") {
            $nomor = '';
        } else {
            return back()->with('error', 'Metode tidak valid');
        }
        

        $deposit = new Deposit();
        $deposit->username = Auth::user()->username;
        $deposit->metode = $request->metode;
        $deposit->no_pembayaran = $nomor;
        $deposit->jumlah = $request->jumlah;
        $deposit->status = "Pending";
        $deposit->save();

        return redirect("".$api->wa_admin."?text=Hallo%20min,%0ASaya%20ingin%20melakukan%20deposit%20sebesar%20*Rp.".number_format($request->jumlah, 0, '.', ',') . ",-*%0AUsername%20:%20*".Auth::user()->username."*%0APembayaran%20:%20*$request->metode*%0A%0AHarap transfer sesuai Jumlah%0ANo. Pembayaran%20:%20*$nomor*%0A%0ASertakan bukti transfer !!%0ANote :%0A> Pembayaran Dana ke Dana Wajib tambah 100 perak!%0A> Pembayaran Dari Bank ke Dana/Gopay/Ovo/Shopee Pay Wajib Tambah 1.500 !!!");
    }
}
